/*
 * Decompiled with CFR 0.152.
 */
package dev.monarkhes.myron.impl.client.model;

import com.mojang.datafixers.util.Pair;
import de.javagl.obj.FloatTuple;
import de.javagl.obj.Obj;
import de.javagl.obj.ObjFace;
import de.javagl.obj.ObjSplitting;
import de.javagl.obj.ReadableObj;
import dev.monarkhes.myron.impl.client.model.MyronBakedModel;
import dev.monarkhes.myron.impl.client.model.MyronMaterial;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_1160;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

public class MyronUnbakedModel
implements class_1100 {
    public static final class_4730 DEFAULT_SPRITE = new class_4730(class_1059.field_5275, null);
    private final Obj obj;
    private final Map<String, MyronMaterial> materials;
    private final class_809 transform;
    private final Collection<class_4730> textureDependencies = new HashSet<class_4730>();
    private final class_4730 sprite;
    private final boolean isSideLit;
    private final class_1160 offset;

    public MyronUnbakedModel(Obj obj, Map<String, MyronMaterial> materials, class_809 transform, boolean isSideLit, class_1160 offset) {
        this.obj = obj;
        this.materials = materials;
        this.transform = transform;
        this.isSideLit = isSideLit;
        this.offset = offset;
        for (MyronMaterial material : materials.values()) {
            this.textureDependencies.add(new class_4730(class_1059.field_5275, material.getTexture()));
        }
        MyronMaterial material = this.getMaterial("sprite");
        this.sprite = materials.size() > 0 ? new class_4730(class_1059.field_5275, (material == null ? materials.values().iterator().next() : material).getTexture()) : DEFAULT_SPRITE;
    }

    private MyronMaterial getMaterial(String name) {
        return this.materials.get(name);
    }

    public Collection<class_2960> method_4755() {
        return Collections.emptyList();
    }

    public Collection<class_4730> method_4754(Function<class_2960, class_1100> unbakedModelGetter, Set<Pair<String, String>> unresolvedTextureReferences) {
        return this.textureDependencies;
    }

    @Nullable
    public class_1087 method_4753(class_1088 loader, Function<class_4730, class_1058> textureGetter, class_3665 settings, class_2960 modelId) {
        Renderer renderer = RendererAccess.INSTANCE.getRenderer();
        if (renderer == null) {
            return null;
        }
        MeshBuilder builder = renderer.meshBuilder();
        QuadEmitter emitter = builder.getEmitter();
        for (Map.Entry entry : ObjSplitting.splitByMaterialGroups((ReadableObj)this.obj).entrySet()) {
            Obj group = (Obj)entry.getValue();
            MyronMaterial material = this.getMaterial((String)entry.getKey());
            if (material == null) {
                material = MyronMaterial.DEFAULT;
            }
            int materialColor = material.getColor();
            class_1058 sprite = textureGetter.apply(new class_4730(class_1059.field_5275, material.getTexture()));
            for (int faceIndex = 0; faceIndex < group.getNumFaces(); ++faceIndex) {
                this.face(renderer, emitter, group, group.getFace(faceIndex), material, materialColor, sprite, settings);
            }
        }
        return new MyronBakedModel(builder.build(), this.transform, textureGetter.apply(this.sprite), this.isSideLit);
    }

    private void face(Renderer renderer, QuadEmitter emitter, Obj group, ObjFace face, MyronMaterial material, int materialColor, class_1058 sprite, class_3665 settings) {
        if (face.getNumVertices() <= 4) {
            for (int vertex = 0; vertex < face.getNumVertices(); ++vertex) {
                this.vertex(emitter, group, face, vertex, settings);
            }
            this.emit(renderer, emitter, material, materialColor, sprite, settings);
        } else {
            int vertices = face.getNumVertices();
            FloatTuple textureCoords = face.containsTexCoordIndices() ? group.getTexCoord(face.getTexCoordIndex(0)) : null;
            class_1160 pos = MyronUnbakedModel.of(group.getVertex(face.getVertexIndex(0)));
            pos.method_23846(this.offset);
            class_1160 normal = MyronUnbakedModel.of(group.getNormal(face.getNormalIndex(0)));
            MyronUnbakedModel.rotate(settings, pos, normal);
            Vertex start = new Vertex(pos, normal, textureCoords == null ? 0.0f : textureCoords.getX(), textureCoords == null ? 0.0f : textureCoords.getY());
            for (int vertex = 1; vertex < vertices - 1; ++vertex) {
                MyronUnbakedModel.vertex(emitter, 0, start.pos, start.normal, start.u, start.v);
                textureCoords = face.containsTexCoordIndices() ? group.getTexCoord(face.getTexCoordIndex(vertex)) : null;
                pos = MyronUnbakedModel.of(group.getVertex(face.getVertexIndex(vertex)));
                pos.method_23846(this.offset);
                normal = MyronUnbakedModel.of(group.getNormal(face.getNormalIndex(vertex)));
                MyronUnbakedModel.rotate(settings, pos, normal);
                MyronUnbakedModel.vertex(emitter, 1, pos, normal, textureCoords == null ? 0.0f : textureCoords.getX(), textureCoords == null ? 0.0f : textureCoords.getY());
                textureCoords = face.containsTexCoordIndices() ? group.getTexCoord(face.getTexCoordIndex(vertex + 1)) : null;
                pos = MyronUnbakedModel.of(group.getVertex(face.getVertexIndex(vertex + 1)));
                pos.method_23846(this.offset);
                normal = MyronUnbakedModel.of(group.getNormal(face.getNormalIndex(vertex + 1)));
                MyronUnbakedModel.rotate(settings, pos, normal);
                MyronUnbakedModel.vertex(emitter, 2, pos, normal, textureCoords == null ? 0.0f : textureCoords.getX(), textureCoords == null ? 0.0f : textureCoords.getY());
                MyronUnbakedModel.vertex(emitter, 3, pos, normal, textureCoords == null ? 0.0f : textureCoords.getX(), textureCoords == null ? 0.0f : textureCoords.getY());
                this.emit(renderer, emitter, material, materialColor, sprite, settings);
            }
        }
    }

    private void emit(Renderer renderer, QuadEmitter emitter, MyronMaterial material, int materialColor, class_1058 sprite, class_3665 settings) {
        emitter.material(material.getMaterial(renderer));
        emitter.spriteColor(0, materialColor, materialColor, materialColor, materialColor);
        emitter.colorIndex(material.getTintIndex());
        emitter.nominalFace(emitter.lightFace());
        if (material.getCullDirection() != null) {
            emitter.cullFace(material.getCullDirection());
        }
        boolean bl = settings.method_3512() || material.isUvLocked();
        emitter.spriteBake(0, sprite, 0x20 | (bl ? 4 : 0));
        emitter.emit();
    }

    private void vertex(QuadEmitter emitter, Obj group, ObjFace face, int vertex, class_3665 settings) {
        class_1160 pos = MyronUnbakedModel.of(group.getVertex(face.getVertexIndex(vertex)));
        pos.method_23846(this.offset);
        class_1160 normal = MyronUnbakedModel.of(group.getNormal(face.getNormalIndex(vertex)));
        float u = 0.0f;
        float v = 0.0f;
        if (face.containsTexCoordIndices()) {
            FloatTuple textureCoords = group.getTexCoord(face.getTexCoordIndex(vertex));
            u = textureCoords.getX();
            v = textureCoords.getY();
        }
        MyronUnbakedModel.rotate(settings, pos, normal);
        MyronUnbakedModel.vertex(emitter, vertex, pos, normal, u, v);
        if (face.getNumVertices() == 3) {
            MyronUnbakedModel.vertex(emitter, vertex + 1, pos, normal, u, v);
        }
    }

    private static void rotate(class_3665 settings, class_1160 pos, class_1160 normal) {
        if (settings.method_3509() != class_4590.method_22931()) {
            pos.method_4948(-0.5f, -0.5f, -0.5f);
            pos.method_19262(settings.method_3509().method_22937());
            pos.method_4948(0.5f, 0.5f, 0.5f);
            normal.method_19262(settings.method_3509().method_22937());
        }
    }

    private static void vertex(QuadEmitter emitter, int vertex, class_1160 pos, class_1160 normal, float u, float v) {
        emitter.pos(vertex, pos);
        emitter.normal(vertex, normal);
        emitter.sprite(vertex, 0, u, v);
    }

    private static class_1160 of(FloatTuple tuple) {
        return new class_1160(tuple.getX(), tuple.getY(), tuple.getZ());
    }

    private static class Vertex {
        public final class_1160 pos;
        public final class_1160 normal;
        public final float u;
        public final float v;

        private Vertex(class_1160 pos, class_1160 normal, float u, float v) {
            this.pos = pos;
            this.normal = normal;
            this.u = u;
            this.v = v;
        }
    }
}

