/*
 * Decompiled with CFR 0.152.
 */
package dev.monarkhes.myron.impl.client.obj;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.monarkhes.myron.impl.client.Myron;
import dev.monarkhes.myron.impl.client.obj.AbstractObjLoader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.ModelProviderContext;
import net.fabricmc.fabric.api.client.model.ModelResourceProvider;
import net.fabricmc.fabric.api.client.model.ModelVariantProvider;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_804;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

public class ObjLoader
extends AbstractObjLoader
implements ModelResourceProvider,
ModelVariantProvider {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_809.class, (Object)new ModelTransformDeserializer()).registerTypeAdapter(class_804.class, (Object)new TransformDeserializer()).create();
    private final class_3300 resourceManager;

    public ObjLoader(class_3300 resourceManager) {
        this.resourceManager = resourceManager;
    }

    @Nullable
    public class_1100 loadModelResource(class_2960 identifier, ModelProviderContext modelProviderContext) {
        return this.loadModel(this.resourceManager, identifier, class_809.field_4301, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public class_1100 loadModelVariant(class_1091 modelIdentifier, ModelProviderContext modelProviderContext) {
        class_2960 resource = new class_2960(modelIdentifier.method_12836(), "models/item/" + modelIdentifier.method_12832() + ".json");
        if (!modelIdentifier.method_4740().equals("inventory")) return null;
        if (!this.resourceManager.method_18234(resource)) {
            return null;
        }
        try (InputStreamReader reader = new InputStreamReader(this.resourceManager.method_14486(resource).method_14482());){
            JsonObject rawModel = class_3518.method_15255((Reader)reader);
            JsonElement model = rawModel.get("model");
            if (!(model instanceof JsonPrimitive) || !((JsonPrimitive)model).isString()) {
                class_1100 class_11002 = null;
                return class_11002;
            }
            class_2960 modelPath = new class_2960(model.getAsString());
            class_809 transformation = this.getTransformation(rawModel);
            boolean isSideLit = true;
            if (rawModel.has("gui_light")) {
                isSideLit = class_3518.method_15265((JsonObject)rawModel, (String)"gui_light").equals("side");
            }
            class_1100 class_11003 = this.loadModel(this.resourceManager, modelPath, transformation, isSideLit);
            return class_11003;
        }
        catch (IOException e) {
            Myron.LOGGER.warn("Failed to load model {}:\n{}", (Object)resource, (Object)e.getMessage());
            return null;
        }
    }

    private class_809 getTransformation(JsonObject rawModel) throws IOException {
        if (rawModel.has("display")) {
            JsonObject rawTransform = class_3518.method_15296((JsonObject)rawModel, (String)"display");
            return (class_809)GSON.fromJson((JsonElement)rawTransform, class_809.class);
        }
        if (rawModel.has("parent")) {
            String[] parentStrings = class_3518.method_15265((JsonObject)rawModel, (String)"parent").split(":");
            class_2960 parent = new class_2960(parentStrings[0], "models/" + parentStrings[1] + ".json");
            return this.getTransformation(parent);
        }
        return class_809.field_4301;
    }

    private class_809 getTransformation(class_2960 model) throws IOException {
        if (this.resourceManager.method_18234(model)) {
            InputStreamReader reader = new InputStreamReader(this.resourceManager.method_14486(model).method_14482());
            return this.getTransformation(class_3518.method_15255((Reader)reader));
        }
        return class_809.field_4301;
    }

    @Environment(value=EnvType.CLIENT)
    public static class TransformDeserializer
    extends class_804.class_805 {
    }

    @Environment(value=EnvType.CLIENT)
    public static class ModelTransformDeserializer
    extends class_809.class_810 {
    }
}

